/* eslint-disable */
import type { ConditionalValue } from '../types/index.d.mts';
import type { DistributiveOmit, Pretty } from '../types/system-types.d.mts';

interface ButtonVariant {
  /**
 * @default "default"
 */
variant: "default" | "destructive" | "outline" | "secondary" | "ghost" | "link"
/**
 * @default "default"
 */
size: "default" | "sm" | "lg" | "icon"
}

type ButtonVariantMap = {
  [key in keyof ButtonVariant]: Array<ButtonVariant[key]>
}

export type ButtonVariantProps = {
  [key in keyof ButtonVariant]?: ConditionalValue<ButtonVariant[key]> | undefined
}

export interface ButtonRecipe {
  __type: ButtonVariantProps
  (props?: ButtonVariantProps): string
  raw: (props?: ButtonVariantProps) => ButtonVariantProps
  variantMap: ButtonVariantMap
  variantKeys: Array<keyof ButtonVariant>
  splitVariantProps<Props extends ButtonVariantProps>(props: Props): [ButtonVariantProps, Pretty<DistributiveOmit<Props, keyof ButtonVariantProps>>]
  getVariantProps: (props?: ButtonVariantProps) => ButtonVariantProps
}

/**
 * Styles for the Button component


 */
export declare const button: ButtonRecipe